#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=292450 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (267999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268246, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-02 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-02 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-02 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-02 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268349, 'Database Backup [database_backup_2025-05-03-00-02-04-v3-1-6.zip]', '2025-05-03 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (268999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 21:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 23:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 23:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 23:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-03 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-03 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-03 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269145, 'Database Backup [database_backup_2025-05-04-00-01-03-v3-1-6.zip]', '2025-05-04 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 02:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 02:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 02:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 03:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 03:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 03:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 05:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 05:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 05:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 19:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 19:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 19:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269836, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-04 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269837, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-05-04 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-04 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-04 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-04 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269940, 'Database Backup [database_backup_2025-05-05-00-04-04-v3-1-6.zip]', '2025-05-05 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (269999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270637, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270740, 'Database Backup [database_backup_2025-05-06-00-02-04-v3-1-6.zip]', '2025-05-06 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271551, 'Database Backup [database_backup_2025-05-07-00-00-05-v3-1-6.zip]', '2025-05-07 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `descrip