#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=320552 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294755, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-06-04 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294855, 'Database Backup [database_backup_2025-06-05-00-01-02-v3-1-6.zip]', '2025-06-05 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 08:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 08:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 08:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 08:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 08:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 08:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 16:00:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 16:00:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 16:00:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 17:00:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 17:00:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 17:00:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295543, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-06-05 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295646, 'Database Backup [database_backup_2025-06-06-00-02-04-v3-1-6.zip]', '2025-06-06 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296337, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-06-06 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296338, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-06-06 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296339, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-06-06 21:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296340, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Due Notice]', '2025-06-06 21:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296431, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:d870:fdfc:fe0d:6bc9]', '2025-06-06 23:33:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296432, 'Invoice Status Updated [Invoice Number: INV-172/05/2025, From: Overdue To: Paid]', '2025-06-06 23:34:43', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296433, 'Payment Recorded [ID:126, Invoice Number: INV-172/05/2025, Total: $200.00]', '2025-06-06 23:34:43', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296434, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-06-06 23:34:49', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296435, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-06-06 23:34:51', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296451, 'Database Backup [database_backup_2025-06-07-00-01-03-v3-1-6.zip]', '2025-06-07 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297151, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-06-07 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-07 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-07 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-07 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297254, 'Database Backup [database_backup_2025-06-08-00-04-02-v3-1-6.zip]', '2025-06-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297939, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-06-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (297999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-08 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-08 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-08 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298039, 'Database Backup [database_backup_2025-06-09-00-02-02-v3-1-6.zip]', '2025-06-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-09 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-09 18:01:03', '