#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=242936 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218288, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-02 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218289, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-02 21:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 21:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 21:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 21:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 23:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 23:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 23:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218389, 'Database Backup [database_backup_2025-03-03-00-00-06-v3-1-6.zip]', '2025-03-03 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 00:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 00:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 00:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 02:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 02:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 02:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219083, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-03 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 21:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 21:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 21:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-03 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-03 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-03 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219189, 'Database Backup [database_backup_2025-03-04-00-01-03-v3-1-6.zip]', '2025-03-04 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 09:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 09:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 09:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 14:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 14:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 14:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-04 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-04 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-04 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219988, 'Database Backup [database_backup_2025-03-05-00-00-03-v3-1-6.zip]', '2025-03-05 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (219999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 13:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 13:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 13:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220703, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-05 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220704, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-05 21:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 21:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 21:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 21:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220810, 'Database Backup [database_backup_2025-03-06-00-03-03-v3-1-6.zip]', '2025-03-06 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:05:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221540, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221649, 'Database Backup [database_backup_2025-03-07-00-02-04-v3-1-6.zip]', '2025-03-07 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `s