#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=274015 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249840, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:16ba:a258:a264:edd8]', '2025-04-10 09:17:41', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249841, 'Invoice Status Updated [Invoice Number: INV-171/03/2025, From: Overdue To: Paid]', '2025-04-10 09:19:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249842, 'Payment Recorded [ID:124, Invoice Number: INV-171/03/2025, Total: 1,350.00$]', '2025-04-10 09:19:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249843, 'Email Sent To [Email: shaykar02@hotmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-04-10 09:19:48', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249844, 'Email Sent To [Email: na@saylesstt.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-04-10 09:19:55', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250247, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-10 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250248, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-10 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250354, 'Database Backup [database_backup_2025-04-11-00-00-03-v3-1-6.zip]', '2025-04-11 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 17:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 17:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 19:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 19:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 19:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251081, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-11 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251184, 'Database Backup [database_backup_2025-04-12-00-01-04-v3-1-6.zip]', '2025-04-12 00:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 05:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 05:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 05:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 14:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 14:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 14:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-12 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-12 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-12 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (251999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252001, 'Database Backup [database_backup_2025-04-13-00-02-02-v3-1-6.zip]', '2025-04-13 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252698, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-13 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252699, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-13 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252805, 'Database Backup [database_backup_2025-04-14-00-00-06-v3-1-6.zip]', '2025-04-14 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253562, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-14 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253665, 'Database Backup [database_backup_2025-04-15-00-03-03-v3-1-6.zip]', '2025-04-15 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253906, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:610c:2b52:a525:73fc]', '2025-04-15 07:16:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com