#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=172743 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148824, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-05 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148927, 'Database Backup [database_backup_2024-12-06-00-03-01-v3-1-6.zip]', '2024-12-06 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149729, 'Database Backup [database_backup_2024-12-07-00-03-01-v3-1-6.zip]', '2024-12-07 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150423, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Due Notice]', '2024-12-07 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150526, 'Database Backup [database_backup_2024-12-08-00-04-02-v3-1-6.zip]', '2024-12-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151214, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-08 21:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 21:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 21:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 21:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-08 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-08 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-08 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151314, 'Database Backup [database_backup_2024-12-09-00-00-02-v3-1-6.zip]', '2024-12-09 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152122, 'Database Backup [database_backup_2024-12-10-00-00-05-v3-1-6.zip]', '2024-12-10 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `descr