#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=179895 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156018, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-14 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156019, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Due Notice]', '2024-12-14 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156122, 'Database Backup [database_backup_2024-12-15-00-05-02-v3-1-6.zip]', '2024-12-15 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-15 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-15 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-15 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156906, 'Database Backup [database_backup_2024-12-16-00-02-02-v3-1-6.zip]', '2024-12-16 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (156999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 04:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 04:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 04:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 05:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 05:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 05:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-16 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-16 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-16 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157687, 'Database Backup [database_backup_2024-12-17-00-02-02-v3-1-6.zip]', '2024-12-17 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (157999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 12:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 12:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 12:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 12:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 12:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 12:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 13:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 13:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 13:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 13:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 13:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 13:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 14:30:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 14:30:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 14:30:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 15:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 15:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 15:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158375, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-17 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158376, 'Invoice Status Updated [Invoice Number: INV-168/12/2024, From: Unpaid To: Overdue]', '2024-12-17 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158377, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2024-12-17 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-17 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-17 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-17 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158480, 'Database Backup [database_backup_2024-12-18-00-02-03-v3-1-6.zip]', '2024-12-18 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159240, 'Database Backup [database_backup_2024-12-19-00-02-03-v3-1-6.zip]', '2024-12-19 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`