#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=227380 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:44:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:44:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:44:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205467, 'Database Backup [database_backup_2025-02-15-00-04-03-v3-1-6.zip]', '2025-02-15 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 19:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 19:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 19:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:38:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:38:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:38:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:38:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 20:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 20:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 20:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206176, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-15 21:01:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206177, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-15 21:01:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206178, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-02-15 21:01:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206179, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-02-15 21:01:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:01:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:01:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:01:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:01:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:01:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:01:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206297, 'Database Backup [database_backup_2025-02-16-00-04-11-v3-1-6.zip]', '2025-02-16 00:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206298, 'Database Backup [database_backup_2025-02-16-00-04-11-v3-1-6-1.zip]', '2025-02-16 00:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:43:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:43:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:43:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 00:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 00:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 00:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 14:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 14:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 14:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 18:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 18:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 18:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 20:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 20:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 20:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206995, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-16 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-16 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-16 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-16 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207095, 'Database Backup [database_backup_2025-02-17-00-04-03-v3-1-6.zip]', '2025-02-17 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 00:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 00:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 00:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207321, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-02-17 07:22:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207325, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-02-17 07:29:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207329, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-02-17 07:35:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-17 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-17 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-17 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207873, 'Database Backup [database_backup_2025-02-18-00-03-02-v3-1-6.zip]', '2025-02-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (207999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208573, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-18 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208574, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-02-18 21:01:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:01:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:01:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:01:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-18 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-18 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-18 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208686, 'Database Backup [database_backup_2025-02-19-00-05-03-v3-1-6.zip]', '2025-02-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208687, 'Database Backup [database_backup_2025-02-19-00-05-03-v3-1-6.zip]', '2025-02-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (208999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:00:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:00:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:00:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-19 16:47:04', '