#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=337621 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312753, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312757, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312761, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312765, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312769, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312773, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312777, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312781, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312785, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312789, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312793, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312797, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312801, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312805, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312809, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312813, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312817, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312821, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312825, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312829, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312833, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312837, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312841, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312845, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312849, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312853, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312857, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312861, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312865, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312869, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312873, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312877, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312881, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312885, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312889, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312893, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312897, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312901, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312905, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312909, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312913, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312917, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312921, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312925, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312929, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312933, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312937, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312941, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312945, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312949, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312953, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312957, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312961, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312965, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312969, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312973, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312977, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312981, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312985, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312989, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312993, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312997, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313001, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313005, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313009, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313013, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313017, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313021, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313025, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313029, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313033, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313037, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313041, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313045, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313049, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313053, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313057, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313061, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313065, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313069, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313073, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313077, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313081, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313085, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313089, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313093, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313097, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313101, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313105, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313109, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313113, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313117, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313121, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313125, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313129, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313133, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313137, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313141, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313145, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313149, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313153, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313157, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313161, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313165, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313169, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313173, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313177, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313181, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313185, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313189, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313193, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313197, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313201, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313205, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313209, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313213, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313217, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313221, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313225, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313229, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313233, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313237, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313241, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313245, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313249, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313253, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313257, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313261, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313265, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313269, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313273, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313277, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313281, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313285, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313289, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313293, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313297, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313301, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313305, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313309, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313313, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313317, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313321, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313325, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313329, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313333, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313337, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313341, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 18:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313345, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 18:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313349, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 18:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313353, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 18:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313357, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 18:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313361, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 18:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313365, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 18:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313369, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 18:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313373, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 18:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313377, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 18:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313381, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 19:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313385, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 19:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313389, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 19:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313393, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 19:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313397, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 19:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313401, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 19:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313405, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 19:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313409, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 19:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313413, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 19:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313417, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 19:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313421, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 19:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313425, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 20:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313429, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 20:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313433, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 20:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313437, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 20:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313441, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 20:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313445, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 20:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313449, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 20:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313453, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 20:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313457, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 20:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313461, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 20:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313465, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313469, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 21:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313473, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 21:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313477, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 21:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313481, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 21:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313485, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 21:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313489, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 21:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313493, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 21:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313497, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 21:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313501, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 21:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313505, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 22:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313509, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 22:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313513, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 22:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313517, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 22:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313521, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 22:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313525, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 22:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313529, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 22:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313533, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 22:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313537, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 22:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313541, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 22:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313545, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 22:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313549, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 23:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313553, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 23:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313557, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 23:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313561, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 23:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313565, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 23:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313569, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 23:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313573, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 23:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313577, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 23:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313581, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 23:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313585, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 23:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313589, 'Database Backup [database_backup_2025-06-27-00-02-03-v3-1-6.zip]', '2025-06-27 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313590, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 00:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313594, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 00:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313598, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 00:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313602, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 00:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313606, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 00:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313610, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 00:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313614, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 00:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313618, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 00:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313622, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 00:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313626, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 00:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313630, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 00:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313634, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 01:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313638, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 01:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313642, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 01:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313646, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 01:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313650, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 01:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313654, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 01:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313658, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 01:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313662, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 01:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313666, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 01:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313670, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 01:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313674, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 02:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313678, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 02:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313682, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 02:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313686, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 02:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313690, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 02:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313694, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 02:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313698, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 02:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313702, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 02:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313706, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 02:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313710, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 02:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313714, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 03:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313718, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 03:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313722, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 03:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313726, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 03:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313730, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 03:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313734, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 03:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313738, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 03:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313742, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 03:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313746, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 03:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313750, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 03:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313754, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 03:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313758, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 04:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313762, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 04:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313766, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 04:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313770, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 04:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313774, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 04:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313778, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 04:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313782, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 04:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313786, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 04:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313790, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 04:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313794, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 04:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313798, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 05:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313802, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 05:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313806, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 05:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313810, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 05:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313814, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 05:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313818, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 05:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313822, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 05:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313826, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 05:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313830, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 05:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313834, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 05:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313838, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 06:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313842, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 06:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313846, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 06:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313850, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 06:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313854, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 06:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313858, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 06:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313862, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 06:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313866, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 06:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313870, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 06:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313874, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 06:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313878, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 07:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313882, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 07:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313886, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 07:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313890, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 07:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313894, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 07:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313898, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 07:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313902, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 07:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313906, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 07:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313910, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 07:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313914, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 07:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313918, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 07:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313922, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 08:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313926, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 08:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313930, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 08:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313934, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 08:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313938, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 08:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313942, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 08:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313946, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 08:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313950, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 08:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313954, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 08:50:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313958, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 08:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313962, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 09:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313966, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 09:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313970, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 09:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313974, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 09:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313978, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 09:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313982, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 09:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313986, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 09:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313990, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 09:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313994, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 09:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313998, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 09:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 09:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 09:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 09:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314002, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 09:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314006, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 10:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314010, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 10:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314014, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 10:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314018, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 10:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314022, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 10:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314026, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 10:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314030, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 10:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314034, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 10:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314038, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 10:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314042, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 10:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314046, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 11:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314050, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 11:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314054, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 11:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314058, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 11:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314062, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 11:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314066, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 11:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314070, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 11:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314074, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 11:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314078, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 11:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314082, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 11:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314086, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 11:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314090, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 12:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314094, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 12:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314098, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 12:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314102, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 12:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314106, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 12:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314110, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 12:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 12:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 12:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 12:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314114, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 12:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314118, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 12:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314122, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 12:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314126, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 12:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314130, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 13:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 13:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 13:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 13:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314134, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 13:07:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314138, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 13:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314142, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 13:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314146, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 13:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314150, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 13:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314154, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 13:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314158, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 13:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314162, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 13:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314166, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 13:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314170, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 14:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314174, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 14:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314178, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 14:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314182, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 14:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314186, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 14:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314190, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 14:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314194, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 14:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314198, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 14:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314202, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 14:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 14:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 14:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 14:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314206, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 14:51:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314210, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 14:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314214, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 15:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314218, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 15:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314222, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 15:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314226, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 15:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314230, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 15:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314234, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 15:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314238, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 15:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314242, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 15:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314246, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 15:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314250, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 15:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314254, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 16:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314258, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 16:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 16:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 16:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 16:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314262, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 16:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314266, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 16:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314270, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 16:23:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314274, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 16:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314278, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 16:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314282, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 16:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314286, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 16:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314290, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 16:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314294, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 16:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314298, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 17:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314302, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 17:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314306, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 17:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314310, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 17:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314314, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 17:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314318, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 17:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314322, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 17:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314326, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 17:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314330, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 17:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314334, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 17:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314338, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 18:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314342, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 18:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314346, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 18:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314350, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 18:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314354, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 18:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314358, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 18:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314362, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 18:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314366, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 18:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314370, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 18:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314374, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 18:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314378, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 18:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314382, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 19:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314386, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 19:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314390, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 19:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314394, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 19:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314398, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 19:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314402, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 19:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314406, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 19:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314410, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 19:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314414, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 19:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314418, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 19:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314422, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 20:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314426, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 20:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314430, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 20:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314434, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 20:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314438, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 20:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314442, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 20:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314446, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 20:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314450, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 20:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314454, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 20:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314458, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 20:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314462, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 20:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 21:04:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 21:04:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 21:04:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314466, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 21:04:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314470, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 21:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314474, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 21:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314478, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 21:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314482, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 21:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314486, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 21:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314490, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 21:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314494, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 21:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314498, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 21:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314502, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 21:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314506, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 22:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314510, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 22:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314514, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 22:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314518, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 22:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314522, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 22:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314526, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 22:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314530, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 22:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314534, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 22:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314538, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 22:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314542, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 22:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314546, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 23:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314550, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 23:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314554, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 23:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314558, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 23:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314562, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 23:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314566, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 23:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314570, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 23:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314574, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 23:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314578, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 23:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314582, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 23:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-27 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-27 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-27 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314586, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-27 23:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314590, 'Database Backup [database_backup_2025-06-28-00-02-04-v3-1-6.zip]', '2025-06-28 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314591, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 00:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314595, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 00:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314599, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 00:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314603, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 00:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314607, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 00:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314611, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 00:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314615, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 00:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314619, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 00:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314623, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 00:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314627, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 00:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314631, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 01:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314635, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 01:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314639, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 01:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314643, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 01:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314647, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 01:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314651, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 01:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314655, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 01:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314659, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314663, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 01:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314667, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 01:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314671, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 02:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314675, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 02:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314679, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 02:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314683, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 02:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314687, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 02:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314691, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 02:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314695, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 02:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314699, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 02:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314703, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 02:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314707, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 02:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314711, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 02:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314715, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 03:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314719, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 03:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314723, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 03:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314727, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 03:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314731, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 03:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314735, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 03:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314739, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 03:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314743, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 03:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314747, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 03:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314751, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 03:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314755, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 04:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314759, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 04:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314763, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 04:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314767, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 04:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314771, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 04:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314775, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 04:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314779, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 04:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314783, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 04:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314787, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 04:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314791, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 04:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314795, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 05:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314799, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 05:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314803, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 05:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314807, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 05:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314811, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 05:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314815, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 05:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314819, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 05:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314823, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 05:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314827, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 05:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314831, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 05:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314835, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 06:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314839, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 06:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314843, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 06:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314847, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 06:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314851, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 06:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314855, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 06:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314859, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 06:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314863, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 06:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314867, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 06:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314871, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 06:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314875, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 06:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314879, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 07:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314883, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 07:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314887, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 07:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314891, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 07:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314895, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 07:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314899, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 07:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314903, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 07:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314907, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 07:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314911, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 07:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314915, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 07:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314919, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 08:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314923, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 08:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314927, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 08:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314931, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 08:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314935, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 08:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314939, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 08:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314943, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 08:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314947, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 08:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314951, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 08:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314955, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 08:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314959, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 09:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314963, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 09:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314967, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 09:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314971, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 09:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314975, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 09:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314979, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 09:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314983, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 09:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314987, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 09:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314991, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 09:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314995, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 09:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (314999, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 10:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315003, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 10:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315007, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 10:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315011, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 10:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315015, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 10:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315019, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 10:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315023, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 10:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315027, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 10:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315031, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 10:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315035, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 10:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315039, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 11:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315043, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 11:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315047, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 11:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315051, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 11:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315055, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 11:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315059, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 11:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315063, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 11:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315067, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 11:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315071, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 11:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315075, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 11:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315079, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 11:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315083, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 12:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315087, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 12:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315091, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 12:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315095, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 12:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315099, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 12:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315103, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 12:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315107, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 12:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315111, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 12:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315115, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 12:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315119, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 12:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315123, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 13:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315127, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 13:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315131, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 13:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315135, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 13:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315139, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 13:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315143, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 13:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315147, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 13:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315151, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 13:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315155, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 13:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315159, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 13:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315163, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 14:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315167, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 14:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315171, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 14:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315175, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 14:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315179, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 14:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315183, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 14:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315187, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 14:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315191, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 14:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315195, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315199, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 14:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315203, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 15:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315207, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 15:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315211, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 15:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315215, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 15:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315219, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 15:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315223, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 15:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315227, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 15:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315231, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 15:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315235, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 15:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315239, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 15:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315243, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 16:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315247, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 16:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315251, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 16:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315255, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 16:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315259, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 16:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315263, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 16:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315267, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 16:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315271, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 16:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315275, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 16:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315279, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 16:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315283, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 16:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315287, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 17:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315291, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 17:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315295, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 17:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315299, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 17:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315303, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 17:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315307, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 17:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315311, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 17:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315315, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 17:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315319, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 17:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315323, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 17:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315327, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 18:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315331, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 18:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315335, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 18:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315339, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 18:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315343, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 18:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315347, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 18:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315351, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 18:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315355, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 18:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315359, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 18:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315363, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 18:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315367, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 19:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315371, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 19:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315375, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 19:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315379, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 19:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315383, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 19:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315387, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 19:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315391, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 19:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315395, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 19:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315399, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 19:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315403, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 19:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315407, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 20:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315411, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 20:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315415, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 20:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315419, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 20:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315423, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 20:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315427, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 20:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315431, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 20:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315435, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 20:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315439, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 20:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315443, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 20:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315447, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 20:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315451, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 21:02:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315455, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 21:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315459, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 21:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315463, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 21:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315467, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 21:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315471, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 21:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315475, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 21:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315479, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 21:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 21:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315487, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 21:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315491, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 22:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315495, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 22:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315499, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 22:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315503, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 22:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315507, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 22:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315511, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 22:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315515, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 22:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315519, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 22:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315523, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 22:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315527, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 22:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315531, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 22:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315535, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 23:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315539, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 23:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315543, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 23:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315547, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 23:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315551, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 23:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315555, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 23:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315559, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 23:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315563, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 23:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315567, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 23:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315571, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-28 23:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315575, 'Database Backup [database_backup_2025-06-29-00-03-02-v3-1-6.zip]', '2025-06-29 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315576, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 00:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315580, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 00:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315584, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 00:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315588, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 00:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315592, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 00:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315596, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 00:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315600, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 00:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315604, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 00:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315608, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 00:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315612, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 00:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315616, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 01:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315620, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 01:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315624, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 01:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315628, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 01:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315632, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 01:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315636, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 01:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315640, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 01:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315644, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315648, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 01:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315652, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 01:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315656, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 02:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315660, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 02:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315664, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 02:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315668, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 02:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315672, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 02:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315676, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 02:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315680, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 02:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315684, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 02:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315688, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 02:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315692, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 02:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315696, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 02:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315700, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 03:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315704, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 03:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315708, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 03:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315712, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 03:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315716, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 03:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315720, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 03:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315724, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 03:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315728, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 03:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315732, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 03:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315736, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 03:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315740, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315744, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315748, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315752, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315756, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315760, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315764, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315768, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315772, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315776, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315780, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315784, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315788, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315792, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315796, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315800, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315804, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315808, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315812, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315816, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315820, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315824, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315828, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315832, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315836, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315840, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315844, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315848, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315852, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315856, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315860, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315864, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315868, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315872, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315876, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315880, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315884, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315888, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315892, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315896, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315900, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315904, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315908, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315912, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315916, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315920, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315924, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315928, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315932, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315936, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315940, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315944, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315948, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315952, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315956, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315960, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315964, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315968, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315972, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315976, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315980, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315984, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315988, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315992, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315996, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316000, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316004, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316008, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316012, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316016, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316020, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316024, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316028, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316032, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316036, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316040, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316044, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316048, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316052, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316056, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316060, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316064, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316068, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316072, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316076, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316080, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316084, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316088, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316092, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316096, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316100, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316104, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316108, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316112, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316116, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316120, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316124, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316128, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316132, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316136, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316140, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316144, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316148, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316152, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316156, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316304, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316308, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316312, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316316, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316320, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316324, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316328, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316332, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316336, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316340, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316344, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316348, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316352, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316356, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316360, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316364, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316368, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316372, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316376, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316380, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316384, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316388, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316392, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316396, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316400, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316404, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316408, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316412, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316416, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316420, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316424, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316428, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316432, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316436, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316440, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316444, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316448, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316452, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316456, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316460, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316464, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316468, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316472, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316476, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316480, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316484, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316488, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316492, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316496, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316500, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316504, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316508, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316512, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316516, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316520, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316524, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316528, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316532, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316536, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316540, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316544, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316548, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316552, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316556, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316560, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316564, 'Database Backup [database_backup_2025-06-30-00-00-03-v3-1-6.zip]', '2025-06-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316565, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316569, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316573, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316577, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316581, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316585, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316589, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316593, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316597, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316601, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316605, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316609, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316613, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316617, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316621, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316625, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316629, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316633, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316637, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316641, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316645, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316649, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316653, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316657, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316661, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316665, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316669, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316673, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316677, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316681, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:54:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:54:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316685, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:54:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316689, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316693, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316697, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316701, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316705, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316709, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316713, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316717, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316721, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316725, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316729, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316733, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316737, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316741, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316745, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316749, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316753, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316757, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316761, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316765, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316769, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316773, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316777, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316781, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316785, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316789, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316793, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316797, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316801, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:41:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316805, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:52:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:52:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316809, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:53:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316813, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:58:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316817, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:04:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316821, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:09:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316825, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:15:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316829, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316833, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:26:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316837, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:32:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:37:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:37:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:37:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316841, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:37:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316845, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316849, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:49:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316853, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:00:39', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:00:48', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316857, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316861, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:06:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316865, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:11:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316869, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:17:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316873, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:22:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:28:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:28:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316877, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:28:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316881, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:34:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316885, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316889, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316893, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316897, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316901, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316905, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316909, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316913, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316917, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316921, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316925, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316929, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316933, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316937, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316941, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316945, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316949, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316953, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316957, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316961, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316965, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316969, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316973, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316977, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316981, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316985, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316989, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316993, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316997, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317001, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317005, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317009, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317013, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317017, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:53:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317021, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317025, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317029, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317033, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317037, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317041, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317045, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317049, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317053, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317057, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317061, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317065, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317069, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317073, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317077, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317081, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317085, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317089, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317093, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317097, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317101, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317105, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317109, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317113, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317117, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317121, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317125, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317129, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317133, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317137, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317141, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:51:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317145, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317149, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317153, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317157, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317161, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317165, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317169, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317173, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317177, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317181, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317185, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317189, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317193, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317197, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317201, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317205, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317209, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317213, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317217, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317221, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317225, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317229, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317233, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317237, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317241, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317245, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317249, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317253, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317257, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317261, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317265, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317269, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317273, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317277, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317281, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317285, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317289, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317293, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317297, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317301, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:39:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317305, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317309, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317313, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317317, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317321, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317325, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317329, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317333, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317337, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317339, 'Failed to