#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=379177 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 09:00:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 09:00:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 09:00:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366460, 'Non Existing User Tried to Login [Email: tishara.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:8798:9a7b:9f07:a6a1:3d4b]', '2025-09-15 09:18:40', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366461, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:8798:9a7b:9f07:a6a1:3d4b]', '2025-09-15 09:21:52', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366465, 'Invoice Status Updated [Invoice Number: INV-189/09/2025, From: Unpaid To: Paid]', '2025-09-15 09:24:07', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366466, 'Payment Recorded [ID:139, Invoice Number: INV-189/09/2025, Total: $500.00]', '2025-09-15 09:24:07', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366467, 'Email Sent To [Email: dallas.f@saylessdigital.io, Template: Invoice Payment Recorded (Sent to Staff)]', '2025-09-15 09:24:10', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 16:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 16:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 16:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366828, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Due Notice]', '2025-09-15 21:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366829, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Due Notice]', '2025-09-15 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366926, 'Database Backup [database_backup_2025-09-16-00-00-04-v3-3-1.zip]', '2025-09-16 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367575, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-16 21:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367576, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-16 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367577, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-16 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367578, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-16 21:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367579, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-16 21:00:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 21:00:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 21:00:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 21:00:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-16 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-16 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-16 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367676, 'Database Backup [database_backup_2025-09-17-00-01-02-v3-3-1.zip]', '2025-09-17 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368328, 'Invoice Status Updated [Invoice Number: INV-192/09/2025, From: Unpaid To: Overdue]', '2025-09-17 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368329, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Invoice Overdue Notice]', '2025-09-17 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368330, 'Email Sent To [Email: support@saylesstt.com, Template: Invoice Overdue Notice]', '2025-09-17 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368427, 'Database Backup [database_backup_2025-09-18-00-03-02-v3-3-1.zip]', '2025-09-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368758, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:8798:79e8:1ee5:3722:2c55]', '2025-09-18 10:42:47', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368759, 'Non Existing User Tried to Login [Email: tishara.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:8798:79e8:1ee5:3722:2c55]', '2025-09-18 10:42:59', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368760, 'Invoice Status Updated [Invoice Number: INV-179/07/2025, From: Overdue To: Partially Paid]', '2025-09-18 10:45:37', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368761, 'Payment Recorded [ID:140, Invoice Number: INV-179/07/2025, Total: $500.00]', '2025-09-18 10:45:37', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368762, 'Email Sent To [Email: dallas.f@saylessdigital.io, Template: Invoice Payment Recorded (Sent to Staff)]', '2025-09-18 10:45:40', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369084, 'Invoice Status Updated [Invoice Number: INV-190/09/2025, From: Unpaid To: Overdue]', '2025-09-18 21:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369085, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369086, 'Invoice Status Updated [Invoice Number: INV-191/09/2025, From: Unpaid To: Overdue]', '2025-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369087, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-18 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369184, 'Database Backup [database_backup_2025-09-19-00-00-03-v3-3-1.zip]', '2025-09-19 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369290, 'Database Backup [database_backup_2025-09-22-06-40-05-v3-3-1.zip]', '2025-09-22 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369729, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369730, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369731, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-22 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369732, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369733, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369734, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369735, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-22 21:03:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369736, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369737, 'Email Sent To [Email: support@saylesstt.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370581, 'Database Backup [database_backup_2025-09-24-00-04-02-v3-3-1.zip]', '2025-09-24 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370736, 'Failed to connect to IMAP auto importing tickets for department support@