#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=189541 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165088, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.166]', '2024-12-26 09:55:56', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165110, 'Invoice Status Updated [Invoice Number: INV-169/11/2024, From: Unpaid To: Overdue]', '2024-12-26 10:29:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165111, 'Invoice Status Updated [Invoice Number: INV-169/11/2024, From: Overdue To: Unpaid]', '2024-12-26 10:30:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165466, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-26 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165467, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165567, 'Database Backup [database_backup_2024-12-27-00-02-02-v3-1-6.zip]', '2024-12-27 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166258, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.166]', '2024-12-27 20:48:28', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166367, 'Database Backup [database_backup_2024-12-28-00-04-02-v3-1-6.zip]', '2024-12-28 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167154, 'Database Backup [database_backup_2024-12-29-00-03-02-v3-1-6.zip]', '2024-12-29 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167212, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.166]', '2024-12-29 01:45:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167747, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.166]', '2024-12-29 17:59:41', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167844, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-29 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167845, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2024-12-29 21:01:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 21:01:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 21:01:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 21:01:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167945, 'Database Backup [database_backup_2024-12-30-00-01-02-v3-1-6.zip]', '2024-12-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168183, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.166]', '2024-12-30 07:20:36', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168751, 'Database Backup [database_backup_2024-12-31-00-02-02-v3-1-6.zip]', '2024-12-31 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:15:02', '[CRON]');
INSERT INTO `tbl